#include "ofxDepthGenerator.h"
#include "ofxOpenNIMacros.h"

XnUInt8 PalletIntsR [256] = {0};
XnUInt8 PalletIntsG [256] = {0};
XnUInt8 PalletIntsB [256] = {0};


void CreateRainbowPallet() {
	unsigned char r, g, b;
	for (int i=1; i<255; i++) {
		if (i<=29) {
			r = (unsigned char)(129.36-i*4.36);
			g = 0;
			b = (unsigned char)255;
		}
		else if (i<=86) {
			r = 0;
			g = (unsigned char)(-133.54+i*4.52);
			b = (unsigned char)255;
		}
		else if (i<=141) {
			r = 0;
			g = (unsigned char)255;
			b = (unsigned char)(665.83-i*4.72);
		}
		else if (i<=199) {
			r = (unsigned char)(-635.26+i*4.47);
			g = (unsigned char)255;
			b = 0;
		}
		else {
			r = (unsigned char)255;
			g = (unsigned char)(1166.81-i*4.57);
			b = 0;
		}
		PalletIntsR[i] = r;
		PalletIntsG[i] = g;
		PalletIntsB[i] = b;
	}
}

unsigned char* ofxDepthGenerator::getPixels() {
	return depth_pixels;
}

unsigned char* ofxDepthGenerator::getGrayPixels(){
	return gray_pixels;
}


ofxDepthGenerator::ofxDepthGenerator(){
	CreateRainbowPallet();	
	depth_coloring = 3;
}

bool ofxDepthGenerator::setup(ofxOpenNIContext* pContext) {
	if(!pContext->isInitialized()) {
		return false;
	}
	
	//context = rContext;
	
	// When the context is using a recording we need to fetch the depth generator.
	// --------------------------------------------------------------------------
	/*
	if(!pContext->isUsingRecording()) {
		XnStatus result = depth_generator.Create(pContext->getXnContext());
		CHECK_RC(result, "Creating depth generator using recording");
	}
	else {
		pContext->getDepthGenerator(this);
	}
	 */
	XnStatus result = XN_STATUS_OK;	
	
	// check if the USER generator exists.
	result = pContext->getXnContext()
					.FindExistingNode(XN_NODE_TYPE_DEPTH, depth_generator);
	SHOW_RC(result, "Find depth generator");
	if(result != XN_STATUS_OK) {
		result = depth_generator.Create(pContext->getXnContext());
		SHOW_RC(result, "Create depth generator");
		if(result != XN_STATUS_OK) {			
			return false;
		}
	}	
	
	
	ofLog(OF_LOG_VERBOSE, "Depth camera inited");
	
	
	//Set the input to VGA (standard is QVGA wich is not supported on the Kinect)

	XnMapOutputMode map_mode; 
	map_mode.nXRes = XN_VGA_X_RES; 
	map_mode.nYRes = XN_VGA_Y_RES;
	map_mode.nFPS = 30;
	
	result = depth_generator.SetMapOutputMode(map_mode);
	max_depth = depth_generator.GetDeviceMaxDepth();		
	
	depth_texture.allocate(map_mode.nXRes, map_mode.nYRes, GL_RGB);		
	depth_pixels = new unsigned char[map_mode.nXRes * map_mode.nYRes * 3];
	gray_pixels = new unsigned char[map_mode.nXRes * map_mode.nYRes];
	memset(depth_pixels, 0, map_mode.nXRes * map_mode.nYRes * 4 * sizeof(unsigned char));
		
	depth_generator.StartGenerating();	
	return true;
	
}

void ofxDepthGenerator::draw(float x, float y, float w, float h, unsigned short* userMask, unsigned short userMaskIndex){
	generateTexture(userMask, userMaskIndex);
	glColor3f(1,1,1);
	depth_texture.draw(x, y, w, h);	
}

xn::DepthGenerator& ofxDepthGenerator::getXnDepthGenerator() {
	return depth_generator;
}


void ofxDepthGenerator::generateTexture(unsigned short* userMask, unsigned short userMaskIndex){
	// get meta-data
	xn::DepthMetaData dmd;
   depth_generator.GetMetaData(dmd);
	
	// get the pixels
	const XnDepthPixel* depth = dmd.Data();
	XN_ASSERT(depth);
	
	if (dmd.FrameID() == 0){
		return;
	}
	if (dmd.PixelFormat() == XN_PIXEL_FORMAT_RGB24) {
		printf("its in yuv\n");
	}
	
	//----
	memset(depth_hist, 0, MAX_DEPTH * sizeof(float));
	unsigned int num_of_points = 0;
	for (XnUInt y = 0; y <dmd.YRes(); ++y) {
      int y_dx = y * dmd.XRes();
		int x_dx = dmd.XOffset();
		for (XnUInt x = 0; x < dmd.XRes(); ++x, ++depth)	{
			if (*depth != 0 &&
             (userMask == NULL ||
              (userMask[y_dx + x_dx + x] != 0 && userMaskIndex == 255) ||
              userMask[y_dx + x_dx + x] == userMaskIndex
             )
            )
         {
				depth_hist[*depth]++;
				num_of_points++;
			}
		}
	}

	for (int i=1; i < MAX_DEPTH; i++) {
		depth_hist[i] += depth_hist[i-1];
	}
	
   if (userMask)
   {
      if(num_of_points) {
         for(int i = 0; i < MAX_DEPTH; ++i) {
            depth_hist[i] = (unsigned int)(192 * (1.0f - (depth_hist[i] / num_of_points))) + 64;
         }
      }
   }
   else
   {
      if(num_of_points) {
         for(int i = 0; i < MAX_DEPTH; ++i) {
            depth_hist[i] = (unsigned int)(255 * (1.0f - (depth_hist[i] / num_of_points)));
         }
      }
   }
	depth = dmd.Data();
	
   static int sShift = 0;
   sShift += 13;
	for(XnUInt y = 0; y < dmd.YRes(); ++y) {
		int y_dx = y * dmd.XRes();
		int x_dx = dmd.XOffset();
		unsigned char * texture = (unsigned char*)depth_pixels + y_dx * 3 + x_dx * 3;
		for(XnUInt x = 0; x < dmd.XRes();  x++, depth++, texture+=3) {
			int hist_value = depth_hist[*depth];
         if (*depth == 0 ||
             (userMask != NULL &&
               ((userMaskIndex == 255 && userMask[y_dx + x_dx + x] == 0) || 
              (userMaskIndex != 255 && userMask[y_dx + x_dx + x] != userMaskIndex)
              )
             )
            )
            hist_value = 0;
         
         texture[0] = 0;
         texture[1] = hist_value;
         texture[2] = hist_value;
      
         /*XnUInt16 col_index = ((*depth + sShift) % 256);
         texture[0] = PalletIntsR[col_index];
         texture[1] = PalletIntsG[col_index];
         texture[2] = PalletIntsB[col_index];*/
         
         gray_pixels[(y_dx + x_dx + x)] = hist_value;
		}
	}
		
	depth_texture.loadData((unsigned char *)depth_pixels,dmd.XRes(), dmd.YRes(), GL_RGB);	
	return;
}
